<section id="shorten" class="home">
    <div class="container text-center">

        <div class="row">
            <div class="col-sm-8 col-sm-offset-2">
                <div class="shorten-title wow zoomIn" data-wow-delay="0.3s">
                    <?php echo h(Configure::read('Option.site_name')); ?>
                </div>

                <?php
                echo $this->Form->create('Link', array(
                    'class'         => 'form text-left',
                    'url'           => array( 'controller' => 'links', 'action' => 'ajaxAdd' ),
                    'inputDefaults' => array(
                        'label' => false,
                        'div'   => false,
                        'error' => array(
                            'attributes' => array( 'wrap' => 'span', 'class' => 'help-block' )
                        )
                    )
                ));
                ?>


                <div class="form-group">
                    <div class="input-group">
                        <div class="input-group-addon"><?php echo $this->Form->label('Link.long_url', '<i class="fa fa-link"></i>', array( 'class' => 'mandatory', 'escape' => false )); ?></div>
                        <?php
                        echo $this->Form->input('Link.long_url', array(
                            'type'        => 'url',
                            'class'       => 'form-control input-lg',
                            'placeholder' => __('Paste a link to shorten it'),
                        ));
                        ?>

                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-addon"><?php echo $this->Form->label('Link.alias', '<i class="fa fa-font"></i>', array( 'class' => 'mandatory', 'escape' => false )); ?></div>

                                <?php
                                echo $this->Form->input('Link.alias', array(
                                    'type'        => 'text',
                                    'class'       => 'form-control input-sm',
                                    'placeholder' => __('Alias'),
                                ));
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-2 col-sm-offset-6">
                        <?php
                        echo $this->Form->button('<i class="fa fa-compress"></i> '.__('Shorten'), array(
                            'type'              => 'submit',
                            'class'             => 'btn btn-default btn-lg pull-right wow tada',
                            'data-wow-duration' => '1s',
                            'data-wow-delay'    => '2.5s',
                            //'data-wow-iteration' => '2',
                            'escape'            => false
                        ));
                        echo $this->Form->end();
                        ?>
                    </div>
                </div>
            </div>

        </div>

        <div class="row">
            <div class="col-sm-8 col-sm-offset-2">
                <div class="add-link-result"></div>
            </div>
        </div>

        <div class="slogan"><?php echo __('%s is a service that takes long URLs and squeezes them into fewer characters to make a link that is easier to share tweet email to friends.', h(Configure::read('Option.site_name'))); ?></div>

    </div>
</section>


<section id="features" class="home">
    <div class="container">
        <div class="section-heading wow bounceIn">
            <h1><?php echo __('Features') ?></h1>
            <div class="divider"></div>
            <p><?php echo __('All Amazing Features') ?></p>
        </div>

        <div class="row">
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0s">
                    <i class="fa fa-bar-chart-o fa-2x"></i>
                    <h3><?php echo __('Advanced Analytics') ?></h3>
                    <p><?php echo __('Advanced Reporting & Analytics by <u>continents</u>, <u>countries</u>, <u>states</u>, <u>cities</u>, <u>device type</u>, <u>device brand</u> & <u>device name</u>') ?></p>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0.3s">
                    <i class="fa fa-tachometer fa-2x"></i>
                    <h3><?php echo __('Featured Administration Panel') ?></h3>
                    <p><?php echo __('Control all of the features from the administration panel with a click of a button.') ?></p>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0.6s">
                    <i class="fa fa-users fa-2x"></i>
                    <h3><?php echo __('Unlimited Members Plans') ?></h3>
                    <p><?php echo __('You can control features for each plan like stats type, ads placement, comments, sharing and timer.') ?></p>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0.9s">
                    <i class="fa fa-file-o fa-2x"></i>
                    <h3><?php echo __('Custom Redirect Page') ?></h3>
                    <p><?php echo __('You can custom you redirect page to feel like your website by adding your logo and colors.') ?></p>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0s">
                    <i class="fa fa-lock fa-2x"></i>
                    <h3><?php echo __('Password Protect') ?></h3>
                    <p><?php echo __('Set a password to protect your links from unauthorized access.') ?></p>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0.3s">
                    <i class="fa fa-share-square-o fa-2x"></i>
                    <h3><?php echo __('Social Media Counts') ?></h3>
                    <p><?php echo __('Display social media counts for most popular networks like Facebook, Google+, Pinterest, LinkedIn, StumbleUpon & Reddit') ?></p>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0.6s">
                    <i class="fa fa-tags fa-2x"></i>
                    <h3><?php echo __('Bundles') ?></h3>
                    <p><?php echo __('Bundle your links for easy access and share them with the public.') ?></p>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0.9s">
                    <i class="fa fa-list fa-2x"></i>
                    <h3><?php echo __('Display Website Articles') ?></h3>
                    <p><?php echo __('Connect your website with the custom redirect page by displaying your articles.') ?></p>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0s">
                    <i class="fa fa-comments fa-2x"></i>
                    <h3><?php echo __('Comments System') ?></h3>
                    <p><?php echo __('The Comments box lets people comment on your links.') ?></p>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0.3s">
                    <i class="fa fa-pencil-square-o fa-2x"></i>
                    <h3><?php echo __('Edit Created Links') ?></h3>
                    <p><?php echo __('%s allows you to modify the long URL behind your customized shortlinks.', h(Configure::read('Option.site_name'))) ?></p>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0.6s">
                    <i class="fa fa-file-text-o fa-2x"></i>
                    <h3><?php echo __('Unlimited Pages') ?></h3>
                    <p><?php echo __('You can easily add Unlimited pages easily from the admin area.') ?></p>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="about-item wow fadeInLeft" data-wow-delay="0.9s">
                    <i class="fa fa-code fa-2x"></i>
                    <h3><?php echo __('Advanced API System') ?></h3>
                    <p><?php echo __('API allows you to develop applications that interface with this service.') ?></p>
                </div>
            </div>
        </div>

    </div>
</section>

<section id="stats" class="home">
    <div class="container">

        <div class="section-heading wow bounceIn">
            <h1><?php echo __('Stats') ?></h1>
            <div class="divider"></div>
            <p><?php echo __('Check Our Statistics') ?></p>
        </div>

        <div class="row">
            <div class="col-sm-4 text-center">
                <i class="fa fa-link fa-2x"></i>
                <span class="display-counter"><?php echo $totalLinks; ?></span>
                <span><?php echo __('Total Links') ?></span>
            </div>
            <div class="col-sm-4 text-center">
                <i class="fa fa-bar-chart-o fa-2x"></i>
                <span class="display-counter"><?php echo $totalHits; ?></span>
                <span><?php echo __('Total Hits') ?></span>
            </div>
            <div class="col-sm-4 text-center">
                <i class="fa fa-users fa-2x"></i>
                <span class="display-counter"><?php echo $totalUsers; ?></span>
                <span><?php echo __('Total Users') ?></span>
            </div>
        </div>
    </div>
</section>

<section id="contact" class="home">
    <div class="container">

        <div class="section-heading wow bounceIn">
            <h1><?php echo __('Contact Us') ?></h1>
            <div class="divider"></div>
            <p><?php echo __('Get in touch') ?></p>
        </div>

        <div class="row">
            <div class="col-md-12">
                <?php
                echo $this->Form->create('Form', array(
                    'url'           => array( 'controller' => 'forms', 'action' => 'contact' ),
                    'inputDefaults' => array(
                        'label'    => false,
                        'div'      => false,
                        'class'    => 'form-control',
                        'required' => 'required',
                        'error'    => array(
                            'attributes' => array( 'wrap' => 'span', 'class' => 'help-block' )
                        )
                    )
                ));
                ?>
                <div class="row">

                    <div class="col-sm-6">
                        <div class="form-group <?php echo($this->Form->isFieldError('contact_name') ? 'has-error' : ''); ?>">
                            <?php echo $this->Form->input('contact_name', array( 'placeholder' => __('Your Name') )); ?>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group <?php echo($this->Form->isFieldError('contact_email') ? 'has-error' : ''); ?>">
                            <?php echo $this->Form->input('contact_email', array( 'placeholder' => __('Your email address') )); ?>
                        </div>
                    </div>

                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group <?php echo($this->Form->isFieldError('contact_subject') ? 'has-error' : ''); ?>">
                            <?php echo $this->Form->input('contact_subject', array( 'placeholder' => __('Your subject') )); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group <?php echo($this->Form->isFieldError('contact_message') ? 'has-error' : ''); ?>">
                            <?php echo $this->Form->input('contact_message', array( 'type' => 'textarea', 'placeholder' => __('Message'), 'rows' => '10' )); ?>
                        </div>

                    </div>
                </div>

                <?php if (isset_recaptcha()) {
    ?>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <script src='https://www.google.com/recaptcha/api.js' async defer></script>
                                <div class="g-recaptcha" data-sitekey="<?php echo Configure::read('Option.recaptcha_siteKey');
    ?>"></div>
                                <?php $this->Form->unlockField('g-recaptcha-response');
    ?>
                            </div>
                        </div>
                    </div>
                <?php 
} ?>

                <div class="row">
                    <div class="col-sm-12">
                        <?php
                        echo $this->Form->button('<i class="fa fa-paper-plane"></i> '.__('Send Message'), array(
                            'type'   => 'submit',
                            'class'  => 'btn btn-primary btn-lg pull-right',
                            'escape' => false
                        ));
                        echo $this->Form->end();
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12 text-center">
                        <div class="contact-result"></div>
                    </div>
                </div>
                </form>
            </div>

        </div>
    </div>
</section>